<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Login;
use Illuminate\Http\Request;
use App\Enums\LoginTypeEnum;
use App\Enums\SocialPlatforms;
use Laravel\Socialite\Facades\Socialite;
use Symfony\Component\HttpFoundation\Response;

class PlatformController extends Controller
{
    public function socialPlatforms()
    {
        return response()->json([
            'success' => true,
            'platforms' => SocialPlatforms::supported(),
        ]);
    }

    public function redirectToProvider(Request $request, $provider)
    {
        if (!in_array($provider, SocialPlatforms::supported())) {
            return response()->json([
                'success' => false,
                'message' => __(':provider is not supported', ['provider' => $provider]),
            ], Response::HTTP_BAD_REQUEST);
        }

        session()->put('product', $request->header('product'));

        return Socialite::driver($provider)->stateless()->redirect();
    }

    public function handleProviderCallback(Request $request, $provider)
    {
        if (!in_array($provider, SocialPlatforms::supported())) {
            return response()->json([
                'success' => false,
                'message' => __(':provider is not supported', ['provider' => $provider]),
            ], Response::HTTP_BAD_REQUEST);
        }

        $user = Socialite::driver($provider)->stateless()->user();

        $authUser = User::findOrCreateUser($user, $provider);

        if (!$authUser->products()->wherePivot('product', session('product'))->exists()) {
            $authUser->products()->attach(session()->pull('product'), [
                'active' => 1,
                'ldate' => now(),
                'date' => now(),
                'language' => session()->pull('language') ?? app()->getLocale(),
            ]);
        }

        // $authUser->tokens()->where('revoked', false)->update(['revoked' => true]);

        $geoip = geoip($request->ip());

        Login::create([
            'ip' => $request->ip(),
            'country' => $geoip->iso_code,
            'os' => $request->userAgent(),
            'browser' => $request->userAgent(),
            'user_id' => $authUser->user_id,
            'date' => now(),
            'timezone' => $geoip->timezone,
            'language' => app()->getLocale(),
            'login_type' => LoginTypeEnum::NORMAL,
        ]);

        $token = $authUser->createToken('SSO API');

        return response()->json([
            'success' => true,
            'token' => $token->accessToken,
            'user' => [
                'username' => $authUser->username,
                'email' => $authUser->email,
                'token_expires_at' => $token->token->expires_at,
            ],
        ]);
    }
}
