<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\SlinkResource;
use App\Models\SLink;
use App\Models\SProvider;
use App\Models\User;
use Illuminate\Http\Request;

class SlinkController extends Controller
{

    public function getLinks(User $user)
    {
        $links = $user->sLinks;
        return response()->json(['data' => SlinkResource::collection($links)]);
    }

    public function saveLink(Request $request, User $user)
    {
        $request->validate([
            'link' => 'required|string',
            'operation' => 'required|string'
        ]);

        $url = $request->get('link');
        $operation = $request->get('operation');

        if (!preg_match("~^https?://~", $url)) {
            $url = "https://{$url}";
        }

        $link = parse_url($url, PHP_URL_HOST);
        $linkParts = explode('.', $link);
        if ($linkParts[0] == "www") {
            unset($linkParts[0]);
            $link = implode('.', $linkParts);
        }
        $linkHost = SProvider::where('domian', 'like', '%' . $link . '%')->first();

        if ($operation == 'new') {
            $currentUserLinks = $user->sLinks()->pluck('type')->toArray();
            $hosts = SProvider::whereNotIn('sp_id', $currentUserLinks)->pluck('domian', 'sp_id')->all();

            $link = parse_url($url, PHP_URL_HOST);
            $linkParts = explode('.', $link);
            if ($linkParts[0] == "www") {
                unset($linkParts[0]);
                $link = implode('.', $linkParts);
            }
            $valid = false;
            foreach ($hosts as $id => $host) {
                if (str_contains($host, $link)) {
                    $valid = true;
                    break;
                }
            }

            if (!$valid) {
                return response()->json(['message' => __("The link doesn't match any of allowed social media providers"), 'success' => false], 422);
            } else {
                SLink::create([
                    'user_id' => $user->user_id,
                    'type' => $linkHost->sp_id,
                    'link' => $url
                ]);
                return response()->json(['message' => __('Link added'), 'success' => true]);
            }
        } else if ($operation == 'edit') {
            $oldHost = parse_url($url, PHP_URL_HOST);
            $oldLinkParts = explode('.', $oldHost);
            if ($oldLinkParts[0] == "www") {
                unset($oldLinkParts[0]);
                $oldHost = implode('.', $oldLinkParts);
            }
            $newHost = parse_url($url, PHP_URL_HOST);
            $newLinkParts = explode('.', $newHost);
            if ($newLinkParts[0] == "www") {
                unset($newLinkParts[0]);
                $newHost = implode('.', $newLinkParts);
            }


            if ($newHost && $newHost == $oldHost) {
                SLink::where([
                    'user_id' => $user->user_id,
                    'type' => $linkHost->sp_id,
                ])->update([
                    'link' => $url
                ]);
                return response()->json(['message' => __('Link updated'), 'success' => true]);
            } else {
                return response()->json(['new' => $newHost, 'old' => $oldHost, 'message' => __("The link doesn't match any of allowed social media providers"), 'success' => false], 422);
            }
        }
    }

    public function deleteLink(Request $request, User $user)
    {
        $request->validate([
            'link' => 'required|url'
        ]);

        $link = $request->get('link');
        SLink::where(['link' => $link, 'user_id' => $user->user_id])->delete();

        return response()->json(['success' => true, 'message' => __('Link deleted')]);
    }
}
