<?php

namespace App\Http\Requests;

use App\Enums;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;

class CreateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email' => [
                'required',
                'max:320',
                Rule::unique('users', 'email'),
            ],
            'username' => [
                'required',
                'min:2',
                'max:64',
                'alpha_dash:ascii',
                Rule::unique('users', 'username'),
            ],
            'phone' => [
                'nullable',
                'max:16',
                Rule::unique('users', 'phone'),
            ],
            'mobile' => [
                'nullable',
                'max:16',
                Rule::unique('users', 'mobile'),
            ],
            'image' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'cover' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'dark_mode' => [
                'boolean'
            ],
            'gender' => [
                'nullable',
                Rule::enum(Enums\GenderEnum::class),
            ],
            'bdate' => [
                'nullable',
                'date',
            ],
            'product_id' => [
                Rule::exists('products', 'product_id')
            ],
            'fname_ar' => [
                'string'
            ],
            'lname_ar' => [
                'string'
            ],
            'fa_name_ar' => [
                'string'
            ],
            'fname_en' => [
                'string'
            ],
            'lname_en' => [
                'string'
            ],
            'fa_name_en' => [
                'string'
            ],
            'verification' => [
                'nullable',
                'integer',
                Rule::enum(Enums\VerificationEnum::class),
            ],
            'verified' => [
                'nullable',
                'integer',
                Rule::enum(Enums\VerifiedEnum::class),
            ],
            'semail' => [
                'nullable',
                Rule::unique('users', 'semail')
            ],
            'na_number' => [
                'string',
                'nullable'
            ],
            'en_address' => [
                'string'
            ],
            'ar_caddress' => [
                'string'
            ],
            // 'en_aboutme' => [
            //     'string'
            // ],
            // 'ar_aboutme' => [
            //     'string'
            // ],
            'timezone' => [
                'string'
            ],
            'city' => [
                'nullable',
            ],
            'show_contact' => [
                'nullable'
            ],
            'nickname' => [
                'nullable'
            ],
            'fax' => [
                'nullable'
            ],
        ];
    }
}
