<?php

namespace App\Http\Requests;

use App\Enums\VerificationEnum;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ResendVerifyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'verification_type' => [
                'required',
                Rule::enum(VerificationEnum::class),
            ],
            'email' => [
                Rule::requiredIf(function () {
                    return $this->verification_type == VerificationEnum::EMAIL->value;
                }),
                'email',
                'max:320',
            ],
            'phone' => [
                Rule::requiredIf(function () {
                    return $this->verification_type == VerificationEnum::SMS->value;
                }),
            ],
        ];
    }
}
