<?php

namespace App\Http\Requests;

use App\Enums;
use App\Enums\NickNameEnum;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email' => [
                'max:320',
                Rule::unique('users', 'email')->ignore($this->user->user_id, 'user_id'),
            ],
            'username' => [
                'min:2',
                'max:64',
                'alpha_dash:ascii',
                Rule::unique('users', 'username')->ignore($this->user->user_id, 'user_id'),
            ],
            'nickname' => [

                'nullable',
                Rule::enum(NickNameEnum::class),
            ],
            'phone' => [
                'nullable',
                'max:16',
                Rule::unique('users', 'phone')->ignore($this->user->user_id, 'user_id'),
            ],
            'image' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'cover' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'dark_mode' => [
                'boolean'
            ],
            'gender' => [
                'nullable',
                Rule::enum(Enums\GenderEnum::class),
            ],
            'bdate' => [
                'nullable',
                'date',
            ],
            // 'product_id' => [
            //     Rule::exists('products', 'product_id')
            // ],
            'fname_ar' => [
                'string'
            ],
            'lname_ar' => [
                'string'
            ],
            'fa_name_ar' => [
                'string'
            ],
            'fname_en' => [
                'string'
            ],
            'lname_en' => [
                'string'
            ],
            'fa_name_en' => [
                'string'
            ],
            'verification' => [
                'nullable',
                'integer',
                Rule::enum(Enums\VerificationEnum::class),
            ],
            'verified' => [
                'nullable',
                'integer',
                Rule::enum(Enums\VerifiedEnum::class),
            ],
            'close' => [
                'nullable',
                'integer',
                Rule::enum(Enums\CloseEnum::class),
            ],
            'semail' => [
                'nullable',
                Rule::unique('users', 'semail')->ignore($this->user->user_id, 'user_id'),
            ],
            'mobile' => [
                'nullable',
                'max:16',
                Rule::unique('users', 'mobile')->ignore($this->user->user_id, 'user_id'),
            ],
            'fax' => [
                'nullable',
                'max:16',
            ],
            'na_number' => [
                'nullable',
                'string'
            ],
            'en_address' => [
                'nullable',
                'string'
            ],
            'ar_address' => [
                'nullable',
                'string'
            ],
            // 'en_aboutme' => [
            //     'nullable',
            //     'string'
            // ],
            // 'ar_aboutme' => [
            //     'nullable',
            //     'string'
            // ],
            'timezone' => [
                'nullable',
                'string'
            ],
            'city' => [
                'nullable',
            ],
            'show_contact' => [
                'nullable'
            ],
            'username_changes' => [
                'nullable'
            ],

            'ar_caddress' => [
                'nullable',
                'string',
                'max:255',
            ],
            'en_caddress' => [
                'nullable',
                'string',
                'max:255',
            ],
            'job' => [
                'nullable',
                'string',
                'max:255',
            ],
            'en_job' => [
                'nullable',
                'string',
                'max:255',
            ],
        ];
    }
}
