<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CountryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->co_id,
            'name' => app()->getLocale() == 'ar' ? $this->country : $this->country_e,
            'code' => $this->code,
            'image' => $this->image,
            'domain_code' => $this->domain_code,
            'cities' => $this->cities ?? [],
        ];
    }
}
