<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if ($request->has('fields')) {
            $fields = explode(',', $request->query('fields'));

            return [
                'user_id' => $this->when(in_array('user_id', $fields) || in_array('users.user_id', $fields), $this->user_id),
                'username' => $this->when(in_array('username', $fields), $this->username),
                'fname' => $this->when(
                    in_array('fname', $fields),
                    app()->getLocale() == 'ar' ? $this->fname_ar : $this->fname_en
                ),
                'lname' => $this->when(
                    in_array('lname', $fields),
                    app()->getLocale() == 'ar' ? $this->lname_ar : $this->lname_en
                ),
                'fa_name' => $this->when(
                    in_array('fa_name', $fields),
                    app()->getLocale() == 'ar' ? $this->fa_name_ar : $this->fa_name_en
                ),
                'email' => $this->when(in_array('email', $fields), $this->email),
                'job' => $this->when(
                    in_array('job', $fields),
                    app()->getLocale() == 'ar' ? $this->job : $this->en_job
                ),
                'company' => $this->when(
                    in_array('company', $fields),
                    app()->getLocale() == 'ar' ? $this->company : $this->en_company
                ),
                'gender' => $this->when(in_array('gender', $fields), $this->gender),
                'phone' => $this->when(in_array('phone', $fields), $this->phone),
                'fax' => $this->when(in_array('fax', $fields), $this->fax),
                'mobile' => $this->when(in_array('mobile', $fields), $this->mobile),
                'post_box' => $this->when(in_array('post_box', $fields), $this->post_box),
                'work_phone' => $this->when(in_array('work_phone', $fields), $this->work_phone),
                'website' => $this->when(in_array('website', $fields), $this->website),
                'bdate' => $this->when(in_array('bdate', $fields), $this->bdate),
                'image_url' => $this->photos()->where('img_id', $this->image)->exists() ? url('storage' . $this->photos()->where('img_id', $this->image)->first()->image) : null,
                'na_number' => $this->when(in_array('na_number', $fields), $this->na_number),
                'address' => $this->when(
                    in_array('address', $fields),
                    app()->getLocale() == 'ar' ? $this->ar_address : $this->en_address
                ),
                'country' => $this->when(in_array('country', $fields), @$this->cityy->co_id),
                'country_name' => $this->when(in_array('country', $fields), app()->getLocale() == 'ar' ? @$this->cityy->country->country : @$this->cityy->country->country_e),
                'city' => $this->when(in_array('city', $fields), $this->city),
                'ccity' => $this->when(in_array('ccity', $fields), $this->ccity),
                'cover' => $this->when(in_array('cover', $fields), $this->cover),
                'caddress' => $this->when(
                    in_array('caddress', $fields),
                    app()->getLocale() == 'ar' ? $this->ar_caddress : $this->en_caddress
                ),
                'aboutme' => $this->when(
                    in_array('aboutme', $fields),
                    app()->getLocale() == 'ar' ? $this->ar_aboutme : $this->en_aboutme
                ),
                'lang' => $this->when(in_array('lang', $fields), $this->lang),
                'nickname' => $this->when(in_array('nickname', $fields), $this->nickname),
                'hide_contact' => $this->when(in_array('hide_contact', $fields), $this->hide_contact),
                'time_zone' => $this->when(in_array('time_zone', $fields), $this->time_zone),
                'dark_mode' => $this->when(in_array('dark_mode', $fields), $this->dark_mode),
                'active' => $this->when(in_array('active', $fields) || in_array('users.active', $fields), $this->active),
                'close' => $this->when(in_array('close', $fields), $this->close),
                'verified' => $this->when(in_array('verified', $fields), $this->verified),
                'show_contact' => $this->when(in_array('show_contact', $fields), $this->show_contact)
            ];
        }

        return [
            'user_id' => $this->user_id,
            'username' => $this->username,
            'fname' => app()->getLocale() == 'ar' ? $this->fname_ar ?? $this->fname_en : $this->fname_en,
            'lname' => app()->getLocale() == 'ar' ? $this->lname_ar ??  $this->lname_en : $this->lname_en,
            'fa_name' => app()->getLocale() == 'ar' ? $this->fa_name_ar ?? $this->fa_name_en : $this->fa_name_en,
            'fname_ar' =>  $this->fname_ar,
            'lname_ar' =>  $this->lname_ar,
            'fa_name_ar' =>  $this->fa_name_ar,
            'fname_en' => $this->fname_en,
            'lname_en' =>  $this->lname_en,
            'fa_name_en' => $this->fa_name_en,
            'email' => $this->email,
            'semail' => $this->semail,
            'job' => app()->getLocale() == 'ar' ? $this->job : $this->en_job,
            'company' => app()->getLocale() == 'ar' ? $this->company : $this->en_company,
            'gender' => $this->gender,
            'phone' => $this->phone,
            'fax' => $this->fax,
            'mobile' => $this->mobile,
            'post_box' => $this->post_box,
            'work_phone' => $this->work_phone,
            'website' => $this->website,
            'bdate' => $this->bdate,
            // 'image_url' => $this->photos()->where('img_id', $this->image)->exists() ?  url('storage' . $this->photos()->where('img_id', $this->image)->first()->image) : null,
            'image_url' => $this->when($this->image, function () {
                $imageRecord = $this->photos()->find($this->image);
                if ($imageRecord && $imageRecord->image) {
                    // $correctBaseUrl = 'https://temu.semicolonplus.com';
                    $correctBaseUrl = config('app.temu_domain');
                    return $correctBaseUrl . '/storage/' . ltrim($imageRecord->image, '/');
                }
                return null;
            }),
            // 'image_url' => 'https://assets.bucketlistly.blog/sites/5adf778b6eabcc00190b75b1/content_entry5adf77af6eabcc00190b75b6/6075185986d092000b192d0a/files/best-free-travel-images-main-image-hd-op.jpg',
            'na_number' => $this->na_number,
            'en_address' => $this->en_address,
            'ar_address' => $this->ar_address,
            'address' => app()->getLocale() == 'ar' ? ($this->ar_address ?? $this->en_address) : ($this->en_address ?? $this->ar_address),
            'city' => $this->when(isset($this->city), $this->city),
            'ccity' => $this->when(isset($this->ccity), $this->ccity),
            'country' => isset($this->cityy) ? $this->cityy->co_id : "",
            'country_name' => isset($this->cityy) ? (app()->getLocale() == 'ar' ? @$this->cityy->country->country : @$this->cityy->country->country_e) : "",
            'city_name' => isset($this->cityy) ? ((app()->getLocale() == 'ar') ? $this->cityy->city : $this->cityy->citye) : "",
            'cover' => $this->cover,
            'caddress' => app()->getLocale() == 'ar' ? $this->ar_caddress : $this->en_caddress,
            'aboutme' => app()->getLocale() == 'ar' ? $this->ar_aboutme : $this->en_aboutme,
            'lang' => $this->lang,
            'nickname' => $this->nickname,
            'hide_contact' => $this->hide_contact,
            'time_zone' => $this->time_zone,
            'dark_mode' => $this->dark_mode,
            'verified' => $this->verified,
            'active' => $this->active,
            'close' => $this->close,
            'token' => $this->remember_token,
            'show_contact' => $this->show_contact,
            'username_changes' => $this->username_changes,
            'user_type' => $this->user_type,
        ];
    }
}
