<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Product extends Model
{
    use HasFactory;

    public $primaryKey = 'product_id';

    public $timestamps = false;

    public $casts = [
        'add_date' => 'datetime',
        'active' => 'boolean',
    ];

    protected $hidden = [
        'key',
    ];


    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'uproducts', 'product_id', 'user_id')
            ->using(ProductUser::class)
            ->withPivot('active', 'ldate', 'date', 'language');
    }
}
