<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Http\UploadedFile;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Image>
 */
class ImageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory()->create()->user_id,
            'image' => UploadedFile::fake()->image('avatar.jpg', 500, 500)->size(100),
            'add_date' => fake()->dateTime,
            'type' =>  rand(1, 2),
        ];
    }
}
