<?php

namespace Database\Factories;

use App\Enums\ActiveEnum;
use App\Enums\GenderEnum;
use App\Enums\DarkModeEnum;
use App\Enums\VerifiedEnum;
use Illuminate\Support\Str;
use App\Enums\VerificationEnum;
use App\Enums\SecretQuestionEnum;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * The current password being used by the factory.
     */
    protected static ?string $password;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'username' => fake()->userName,
            'fname_en' => fake()->firstName,
            'lname_en' => fake()->lastName,
            'fa_name_en' => fake()->firstName,
            'language' => fake()->randomElement(['en', 'ar']),
            'password' => static::$password ??= Hash::make('password'),
            'npassword' => static::$password ??= Hash::make('password'),
            'active_key' => Str::random(10),
            'email' => fake()->unique()->freeEmail,
            'semail' => fake()->unique()->safeEmail,
            'gender' => fake()->randomElement(GenderEnum::cases())->value,
            'bdate' => fake()->date,
            'active' => ActiveEnum::YES->value,
            'na_number' => Str::random(10),
            'verified' => VerifiedEnum::YES->value,
            'email_verified_at' => now(),
            'verification' => VerificationEnum::EMAIL->value,
            'verification_code' => rand(100000, 999999),
            'verification_code_expires_at' => now()->addMinutes(5),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn(array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
