/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */
;

/*!40103 SET TIME_ZONE='+00:00' */
;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */
;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */
;

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */
;

/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */
;

DROP TABLE IF EXISTS `accgroups`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `accgroups` (
  `acc_id` int NOT NULL AUTO_INCREMENT COMMENT 'just auto key ',
  `group_id` int NOT NULL,
  `action_id` int NOT NULL,
  PRIMARY KEY (`acc_id`),
  KEY `group_id` (`group_id`),
  KEY `action_id` (`action_id`),
  KEY `acc_id` (`acc_id`),
  KEY `group_id_2` (`group_id`),
  CONSTRAINT `accgroups_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `accgroups_ibfk_3` FOREIGN KEY (`action_id`) REFERENCES `actions` (`action_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = ' Access Actions Group  : join table bettwen   ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `accusers`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `accusers` (
  `acce_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `group_id` int NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` int NOT NULL DEFAULT '1' COMMENT '1=Active | 0=inactive ',
  PRIMARY KEY (`acce_id`),
  KEY `user_id` (`user_id`),
  KEY `group_id` (`group_id`),
  KEY `acce_id` (`acce_id`),
  CONSTRAINT `accusers_ibfk_3` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `accusers_ibfk_4` FOREIGN KEY (`group_id`) REFERENCES `groups` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `accusers_ibfk_7` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `accusers_ibfk_8` FOREIGN KEY (`group_id`) REFERENCES `groups` (`group_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Access Via Groups - level 2';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `actions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `actions` (
  `action_id` int NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL COMMENT 'Module.controller.action',
  `product_id` int NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`action_id`),
  KEY `product_id` (`product_id`),
  KEY `action_id` (`action_id`),
  CONSTRAINT `actions_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'save actionsand controllers name in this table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `activity`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `activity` (
  `ac_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `type` int NOT NULL COMMENT 'type of activity like 1 =forget password request ',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(16) NOT NULL,
  PRIMARY KEY (`ac_id`),
  KEY `user_id` (`user_id`),
  KEY `ac_id` (`ac_id`),
  CONSTRAINT `activity_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Activity log " Send forget password requsets ..etc" ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `ads`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `ads` (
  `ad_id` int NOT NULL AUTO_INCREMENT COMMENT 'pk',
  `link` varchar(255) NOT NULL COMMENT 'ads link',
  `image` varchar(30) NOT NULL COMMENT 'Ads image',
  `user_id` int NOT NULL COMMENT 'ads writer ',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `timer` int NOT NULL COMMENT 'how ads will be display for evrey user | values range 1->9',
  `enddate` date NOT NULL COMMENT 'End date',
  `active` int NOT NULL DEFAULT '0' COMMENT '1=Active || 0=Inactive',
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ad_id`),
  KEY `user_id` (`user_id`),
  KEY `ad_id` (`ad_id`),
  CONSTRAINT `ads_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Ads Table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `ads_options`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `ads_options` (
  `ado_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `ad_id` int NOT NULL COMMENT 'FK',
  `lang` int NOT NULL COMMENT 'ads Language ',
  `product_id` int NOT NULL COMMENT 'Product Id',
  PRIMARY KEY (`ado_id`),
  KEY `ad_id` (`ad_id`),
  KEY `lang` (`lang`),
  KEY `ado_id` (`ado_id`),
  CONSTRAINT `ads_options_ibfk_3` FOREIGN KEY (`ad_id`) REFERENCES `ads` (`ad_id`) ON DELETE CASCADE,
  CONSTRAINT `ads_options_ibfk_4` FOREIGN KEY (`lang`) REFERENCES `languages` (`lan_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Ads Options Table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `ads_tracking`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `ads_tracking` (
  `a_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `ado_id` int NOT NULL COMMENT 'FK',
  `user_id` int NOT NULL COMMENT 'user ',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `country` varchar(4) NOT NULL,
  PRIMARY KEY (`a_id`),
  KEY `user_id` (`user_id`),
  KEY `ado_id` (`ado_id`),
  KEY `a_id` (`a_id`),
  CONSTRAINT `ads_tracking_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `ads_tracking_ibfk_2` FOREIGN KEY (`ado_id`) REFERENCES `ads_options` (`ado_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Ads Tracking ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `bc_download_center`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `bc_download_center` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `file_info` varchar(250) NOT NULL,
  `added_date` datetime NOT NULL,
  `added_by` int NOT NULL,
  `file_size` int NOT NULL,
  `file_type` varchar(4) NOT NULL,
  `product_id` int NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `language` char(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `bc_statistics`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `bc_statistics` (
  `id` int NOT NULL,
  `downloading_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `product_id` int DEFAULT NULL,
  `user_id` int NOT NULL,
  `ip` varchar(20) NOT NULL,
  `file_id` int NOT NULL,
  `country` varchar(2) NOT NULL,
  `browser` varchar(40) NOT NULL,
  `os` varchar(50) NOT NULL,
  `language` varchar(2) NOT NULL,
  KEY `file_id` (`file_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `black_list`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `black_list` (
  `w_id` int NOT NULL AUTO_INCREMENT,
  `word` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`w_id`),
  KEY `w_id` (`w_id`)
) ENGINE = InnoDB DEFAULT CHARSET = latin1;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `cache`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `cache` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `cache_locks`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `cache_locks` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `cities`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `cities` (
  `ci_id` int NOT NULL AUTO_INCREMENT,
  `city` varchar(120) NOT NULL,
  `citye` varchar(120) NOT NULL,
  `co_id` int NOT NULL COMMENT 'FK',
  PRIMARY KEY (`ci_id`),
  KEY `co_id` (`co_id`),
  KEY `ci_id` (`ci_id`),
  CONSTRAINT `cities_ibfk_1` FOREIGN KEY (`co_id`) REFERENCES `countries` (`co_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'cities table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `countries`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `countries` (
  `co_id` int NOT NULL AUTO_INCREMENT,
  `country` varchar(255) NOT NULL,
  `country_e` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `image` varchar(255) NULL COMMENT 'country flag ',
  `domain_code` varchar(4) NOT NULL,
  PRIMARY KEY (`co_id`),
  KEY `co_id` (`co_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'countries table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `covers`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `covers` (
  `cov_id` int NOT NULL AUTO_INCREMENT,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `image` varchar(30) NOT NULL,
  PRIMARY KEY (`cov_id`),
  KEY `cov_id` (`cov_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Default covers ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `deleted_users`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `deleted_users` (
  `del_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `deleted_by` int NOT NULL,
  `user_info` text NOT NULL,
  `product_id` int NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`del_id`),
  KEY `del_id` (`del_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'The list of deleted users ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `failed_jobs`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `groups`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `groups` (
  `group_id` int NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `product_id` int NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` int NOT NULL DEFAULT '1',
  `invariable` int NOT NULL DEFAULT '0' COMMENT 'invariable group',
  `desc` varchar(255) NOT NULL COMMENT 'description ',
  PRIMARY KEY (`group_id`),
  KEY `product_id` (`product_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `groups_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Groups list ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `hc_articles`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `hc_articles` (
  `ar_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `title` varchar(200) NOT NULL,
  `article` longtext NOT NULL,
  `language` varchar(2) NOT NULL,
  `user_id` int NOT NULL,
  `privacy` int NOT NULL COMMENT '0=public | 1=users',
  `sort_order` int NOT NULL,
  `status` int NOT NULL COMMENT '0=inactive | 1=active',
  `page` varchar(100) NOT NULL,
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `se_id` int NOT NULL COMMENT 'FK',
  PRIMARY KEY (`ar_id`),
  KEY `user_id` (`user_id`),
  KEY `se_id` (`se_id`),
  KEY `ar_id` (`ar_id`),
  CONSTRAINT `hc_articles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `hc_articles_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `hc_articles_ibfk_3` FOREIGN KEY (`se_id`) REFERENCES `hc_sections` (`se_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Help center: Articles  table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `hc_rating`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `hc_rating` (
  `r_id` int NOT NULL AUTO_INCREMENT,
  `rating` int NOT NULL COMMENT 'number from 1 to 5 ',
  `user_id` int NOT NULL,
  `rating_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ar_id` int NOT NULL,
  PRIMARY KEY (`r_id`),
  KEY `user_id` (`user_id`),
  KEY `ar_id` (`ar_id`),
  KEY `r_id` (`r_id`),
  CONSTRAINT `hc_rating_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `hc_rating_ibfk_2` FOREIGN KEY (`ar_id`) REFERENCES `hc_articles` (`ar_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Help center:  Rating  table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `hc_sections`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `hc_sections` (
  `se_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `title_ar` varchar(150) NOT NULL,
  `title_en` varchar(150) NOT NULL,
  `privacy` int NOT NULL COMMENT '0=public | 1=users',
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL COMMENT '0=inactive | 1=active',
  `sort_order` int NOT NULL COMMENT 'Order key',
  `product_id` int NOT NULL COMMENT 'FK',
  PRIMARY KEY (`se_id`),
  KEY `product_id` (`product_id`),
  KEY `se_id` (`se_id`),
  CONSTRAINT `hc_sections_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Help center: Sections table  ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `hc_supervisors`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `hc_supervisors` (
  `sup_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `status` int NOT NULL COMMENT '0=inactive | 1=active',
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`sup_id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  KEY `sup_id` (`sup_id`),
  CONSTRAINT `hc_supervisors_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `hc_supervisors_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Help center:  supervisors table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `hc_tracking`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `hc_tracking` (
  `t_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `ar_id` int NOT NULL COMMENT 'FK',
  `user_id` int NOT NULL COMMENT 'FK',
  `product_id` int NOT NULL COMMENT 'FK',
  `visiting_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`t_id`),
  KEY `ar_id` (`ar_id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  KEY `t_id` (`t_id`),
  CONSTRAINT `hc_tracking_ibfk_1` FOREIGN KEY (`ar_id`) REFERENCES `hc_articles` (`ar_id`),
  CONSTRAINT `hc_tracking_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `hc_tracking_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Help center:  tracking table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `images`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `images` (
  `img_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `image` varchar(100) NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` int NOT NULL DEFAULT '1' COMMENT '1=profile || 2=Cover',
  PRIMARY KEY (`img_id`),
  KEY `user_id` (`user_id`),
  KEY `img_id` (`img_id`),
  CONSTRAINT `images_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Users Images ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `job_batches`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `job_batches` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `jobs`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `languages`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `languages` (
  `lan_id` int NOT NULL AUTO_INCREMENT COMMENT 'pr_key',
  `title` varchar(100) NOT NULL COMMENT 'language title',
  `code` varchar(4) NOT NULL COMMENT 'language code like ar for Arabic',
  `user_id` int NOT NULL COMMENT 'Add by ',
  PRIMARY KEY (`lan_id`),
  KEY `user_id` (`user_id`),
  KEY `lan_id` (`lan_id`),
  CONSTRAINT `languages_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `laravel_sessions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `laravel_sessions` (
  `id` VARCHAR(255) NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `product_id` int NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `country` varchar(5) NOT NULL COMMENT 'country code',
  `browser` varchar(25) NOT NULL COMMENT 'User   Browser',
  `lang` varchar(5) NOT NULL COMMENT 'User  Language',
  `os` varchar(20) NOT NULL COMMENT ' User   system',
  `last_activity` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `laravel_sessions_user_id_index` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `login`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `login` (
  `lo_id` int NOT NULL AUTO_INCREMENT,
  `ip` varchar(16) NOT NULL,
  `country` varchar(5) NOT NULL COMMENT 'country code',
  `os` varchar(255) NOT NULL,
  `browser` varchar(255) NOT NULL,
  `user_id` int NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timezone` varchar(255) NOT NULL,
  `language` varchar(255) NOT NULL,
  `login_type` tinyint DEFAULT '1' COMMENT ' 1=Normal | 2=Facebook | 3=LinkedIn| 4=Google | 5=GitHub | 6=GitLab | 7=Bitbucket | 8=Slack',
  PRIMARY KEY (`lo_id`),
  KEY `user_id` (`user_id`),
  KEY `lo_id` (`lo_id`),
  CONSTRAINT `login_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `login_as_trainer`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `login_as_trainer` (
  `la_id` int NOT NULL AUTO_INCREMENT,
  `ip` varchar(16) NOT NULL,
  `country` varchar(5) NOT NULL,
  `os` varchar(15) NOT NULL,
  `user_id` int NOT NULL,
  `login_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `product_id` int NOT NULL,
  `browser` varchar(15) NOT NULL,
  `admin_id` int NOT NULL,
  PRIMARY KEY (`la_id`),
  KEY `product_id` (`product_id`),
  KEY `la_id` (`la_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Login as  trainer';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `migrations`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `newcities`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `newcities` (
  `nc_id` int NOT NULL AUTO_INCREMENT,
  `city` varchar(120) NOT NULL,
  `citye` varchar(120) NOT NULL,
  `user_id` int NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` int NOT NULL COMMENT '1=Active || 0=Inactive',
  `co_id` int NOT NULL COMMENT 'country',
  PRIMARY KEY (`nc_id`),
  KEY `user_id` (`user_id`),
  KEY `co_id` (`co_id`),
  KEY `nc_id` (`nc_id`),
  CONSTRAINT `newcities_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `newcities_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `newcities_ibfk_3` FOREIGN KEY (`co_id`) REFERENCES `countries` (`co_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Cities from users ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `nicknames`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `nicknames` (
  `nn_id` int NOT NULL AUTO_INCREMENT,
  `name_ar` varchar(25) NOT NULL,
  `symbol_ar` varchar(15) NOT NULL,
  `name_en` varchar(25) NOT NULL,
  `symbol_en` varchar(10) NOT NULL,
  PRIMARY KEY (`nn_id`),
  KEY `nn_id` (`nn_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Nicknames ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `ninfo`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `ninfo` (
  `n_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `user_id` int NOT NULL,
  `fname_ar` varchar(15) NOT NULL COMMENT 'First Name in Arabic',
  `lname_ar` varchar(15) NOT NULL COMMENT 'Last name in Arabic',
  `fa_name_ar` varchar(15) NOT NULL COMMENT 'Father name in Arabic',
  `fname_en` varchar(15) NOT NULL COMMENT 'First Name in ohter language',
  `lname_en` varchar(15) NOT NULL COMMENT 'Last name in ohter language',
  `fa_name_en` varchar(15) NOT NULL COMMENT 'Father name in ohter language',
  `na_number` varchar(18) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` int NOT NULL COMMENT '1=Active |0=Inactive',
  PRIMARY KEY (`n_id`),
  KEY `user_id` (`user_id`),
  KEY `n_id` (`n_id`),
  CONSTRAINT `ninfo_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'New Information from users ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `notifications`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `notifications` (
  `n_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `type` int NOT NULL,
  `read` int NOT NULL COMMENT '1=read || 0= unread',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `do` int NOT NULL DEFAULT '0',
  `see_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `do_by` int DEFAULT NULL,
  PRIMARY KEY (`n_id`),
  KEY `user_id` (`user_id`),
  KEY `do_by` (`do_by`),
  KEY `n_id` (`n_id`),
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `notifications_ibfk_2` FOREIGN KEY (`do_by`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Notifications table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `oauth_access_tokens`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `client_id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `oauth_auth_codes`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `client_id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `oauth_clients`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `oauth_clients` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `oauth_personal_access_clients`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `oauth_refresh_tokens`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `password_reset_tokens`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `pimages`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `pimages` (
  `product_id` int NOT NULL,
  `lang_id` int NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`product_id`, `lang_id`),
  KEY `lang_id` (`lang_id`),
  KEY `product_id` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `products`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) NOT NULL,
  `product_name_en` varchar(150) NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `domain` varchar(255) NOT NULL,
  `dashboard_domain` varchar(255),
  `invariable` int NOT NULL DEFAULT '0' COMMENT '1=invariable |0=variable',
  `description` varchar(255) NOT NULL,
  `active` int NOT NULL DEFAULT '1' COMMENT '1=active |inactive=0',
  `logo` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `product_id` (`product_id`),
  UNIQUE KEY `products_key_unique` (`key`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `questions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `questions` (
  `q_id` int NOT NULL AUTO_INCREMENT,
  `question` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `by` int NOT NULL COMMENT 'Asker',
  `lan_id` int NOT NULL COMMENT 'language ',
  `active` int NOT NULL COMMENT 'Active=1 | Inactive=0',
  PRIMARY KEY (`q_id`),
  KEY `by` (`by`),
  KEY `lan_id` (`lan_id`),
  KEY `q_id` (`q_id`),
  CONSTRAINT `questions_ibfk_1` FOREIGN KEY (`by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `questions_ibfk_2` FOREIGN KEY (`lan_id`) REFERENCES `languages` (`lan_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Scret  questions table';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `security_alerts`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `security_alerts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `alert_message` varchar(1000) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `attack_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `browser_type` varchar(30) NOT NULL,
  `country` varchar(4) NOT NULL,
  `language` varchar(4) NOT NULL,
  `page` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Security alerts devloped by samilox ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `selected_covers`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `selected_covers` (
  `scc_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `cov_id` int NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`scc_id`),
  KEY `user_id` (`user_id`),
  KEY `cov_id` (`cov_id`),
  KEY `scc_id` (`scc_id`),
  CONSTRAINT `selected_covers_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `selected_covers_ibfk_2` FOREIGN KEY (`cov_id`) REFERENCES `covers` (`cov_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Selected covers ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `sessions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `sessions` (
  `as` int NOT NULL AUTO_INCREMENT COMMENT 'pk',
  `session_id` varchar(55) NOT NULL COMMENT 'session id  that saved in cookie ',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int NOT NULL,
  `ip` varchar(16) NOT NULL COMMENT 'User  IP',
  `country` varchar(5) NOT NULL COMMENT 'country code',
  `browser` varchar(25) NOT NULL COMMENT 'User   Browser',
  `lang` varchar(5) NOT NULL COMMENT 'User  Language',
  `os` varchar(20) NOT NULL COMMENT ' User   system',
  PRIMARY KEY (`as`),
  KEY `user_id` (`user_id`),
  KEY `as` (`as`),
  CONSTRAINT `sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Users Active Sessions ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `siteoptions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `siteoptions` (
  `op_id` int NOT NULL AUTO_INCREMENT,
  `ctimer` int NOT NULL COMMENT 'cookie timer ',
  `smessage` int NOT NULL COMMENT 'Stop message',
  PRIMARY KEY (`op_id`),
  KEY `op_id` (`op_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Site options table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `slinks`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `slinks` (
  `s_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `user_id` int NOT NULL COMMENT 'User ID',
  `type` int NOT NULL COMMENT 'FK ',
  `link` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`s_id`),
  KEY `user_id` (`user_id`),
  KEY `type` (`type`),
  KEY `s_id` (`s_id`),
  CONSTRAINT `slinks_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `slinks_ibfk_2` FOREIGN KEY (`type`) REFERENCES `sprovider` (`sp_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Social links ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `social_identities`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `social_identities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `provider_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_identities_provider_id_unique` (`provider_id`),
  KEY `social_identities_user_id_foreign` (`user_id`),
  CONSTRAINT `social_identities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `sprovider`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `sprovider` (
  `sp_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `title` varchar(150) NOT NULL COMMENT 'Arabic Title',
  `etitle` varchar(150) NOT NULL COMMENT 'English Title',
  `image` varchar(50) NOT NULL COMMENT 'image ',
  `domian` varchar(50) NOT NULL COMMENT 'provider domain',
  PRIMARY KEY (`sp_id`),
  KEY `sp_id` (`sp_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'social networks  providers ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `trainer_visitors`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `trainer_visitors` (
  `language` varchar(2) NOT NULL,
  `visit_id` int NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) NOT NULL,
  `country` varchar(4) NOT NULL,
  `browser` varchar(25) NOT NULL,
  `visit_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int NOT NULL,
  `os` varchar(35) NOT NULL,
  PRIMARY KEY (`visit_id`),
  KEY `user_id` (`user_id`),
  KEY `visit_id` (`visit_id`),
  CONSTRAINT `trainer_visitors_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Tracking Trainer Profile ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `uproducts`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `uproducts` (
  `up_id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `user_id` int NOT NULL,
  `token` varchar(200) NOT NULL,
  `active` int NOT NULL DEFAULT 1 COMMENT '1=active |inactive=0',
  `ldate` date NULL COMMENT 'unlock date ',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `language` varchar(2) NULL COMMENT 'user language for current product ',
  PRIMARY KEY (`up_id`),
  KEY `product_id` (`product_id`),
  KEY `user_id` (`user_id`),
  KEY `up_id` (`up_id`),
  CONSTRAINT `uproducts_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `uproducts_ibfk_4` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `useroptions`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `useroptions` (
  `no_id` int NOT NULL AUTO_INCREMENT COMMENT 'PK',
  `lan_id` int NOT NULL COMMENT 'language id',
  `user_id` int NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`no_id`),
  KEY `lan_id` (`lan_id`),
  KEY `user_id` (`user_id`),
  KEY `no_id` (`no_id`),
  CONSTRAINT `useroptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `useroptions_ibfk_2` FOREIGN KEY (`lan_id`) REFERENCES `languages` (`lan_id`),
  CONSTRAINT `useroptions_ibfk_3` FOREIGN KEY (`lan_id`) REFERENCES `languages` (`lan_id`),
  CONSTRAINT `useroptions_ibfk_4` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Users options table ';

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `users`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `users` (
  `user_id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `fname_ar` varchar(255) DEFAULT NULL,
  `lname_ar` varchar(255) DEFAULT NULL,
  `fa_name_ar` varchar(255) DEFAULT NULL,
  `fname_en` varchar(255) DEFAULT NULL,
  `lname_en` varchar(255) DEFAULT NULL,
  `fa_name_en` varchar(255) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `npassword` varchar(255) DEFAULT NULL,
  `active_key` varchar(255) DEFAULT NULL,
  `email` varchar(320) NOT NULL,
  `semail` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `job` varchar(255) DEFAULT NULL,
  `en_job` varchar(255) DEFAULT NULL,
  `en_company` varchar(255) DEFAULT NULL,
  `secret_a` varchar(255) DEFAULT NULL,
  `secret_q` int DEFAULT NULL COMMENT 'Secret Questions id ',
  `reg_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'registertion  date ',
  `gender` int NOT NULL DEFAULT '2' COMMENT '1=male | 0=fmale | 2=unkown',
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `post_box` varchar(255) DEFAULT NULL,
  `work_phone` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `city` int DEFAULT NULL,
  `bdate` varchar(255) DEFAULT NULL,
  `active` varchar(255) DEFAULT 1,
  `image` int DEFAULT NULL,
  `na_number` varchar(255) DEFAULT NULL,
  `en_address` varchar(255) DEFAULT NULL,
  `ar_address` varchar(255) DEFAULT NULL,
  `s_code` varchar(255) DEFAULT NULL,
  `token_id` varchar(255) DEFAULT NULL,
  `cover` int DEFAULT NULL,
  `ccity` int DEFAULT NULL COMMENT 'current city',
  `en_caddress` varchar(255) DEFAULT NULL,
  `ar_caddress` varchar(255) DEFAULT NULL,
  `en_aboutme` varchar(255) DEFAULT NULL,
  `ar_aboutme` varchar(255) DEFAULT NULL,
  `lang` int DEFAULT NULL COMMENT 'language',
  `language` varchar(5)  DEFAULT 'en',
  `pincode` varchar(255) DEFAULT NULL,
  `close` int NOT NULL DEFAULT '0' COMMENT 'close account status ',
  `close_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'close account date',
  `inactive_by` int DEFAULT NULL COMMENT 'User who inactivate this user',
  `added_by` int DEFAULT NULL COMMENT 'who is added this user from other products  ',
  `added_product` int DEFAULT NULL COMMENT 'product id wich added  user from it ',
  `pass_code` varchar(255) DEFAULT NULL,
  `active_code` varchar(255) DEFAULT NULL,
  `nickname` int DEFAULT NULL,
  `hide_contact` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1= hide | 0= show them',
  `time_zone` varchar(255) DEFAULT NULL,
  `ann_id` varchar(255) DEFAULT NULL,
  `edu_id` varchar(255) DEFAULT NULL,
  `hide_in_all_products` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=show in all products | 1=hide in all products ',
  `public_key` varchar(255) DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `dark_mode` tinyint DEFAULT '1' COMMENT '1=no | 2=yes',
  `verification` tinyint DEFAULT '1' COMMENT '1=email | 2=sms',
  `verified` tinyint DEFAULT '1' COMMENT ' 1=no | 2=yes',
  `registration_type` tinyint DEFAULT '1' COMMENT ' 1=Normal | 2=Facebook | 3=LinkedIn| 4=Google | 5=GitHub | 6=GitLab | 7=Bitbucket | 8=Slack',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `verification_code` varchar(6) DEFAULT NULL,
  `verification_code_expires_at` timestamp NULL DEFAULT NULL,
  `last_active_at` timestamp NULL DEFAULT NULL,
  `user_type` tinyint NOT NULL DEFAULT '1',
  `username_changes` tinyint Default '5',
  `show_contact` tinyint DEFAULT '1' COMMENT '1=yes | 0=no',

  PRIMARY KEY (`user_id`),
  KEY `city` (`city`),
  KEY `image` (`image`),
  KEY `cover` (`cover`),
  KEY `ccity` (`ccity`),
  KEY `secret_q` (`secret_q`),
  KEY `users_ibfk_6` (`lang`),
  KEY `user_id` (`user_id`),
  KEY `users_ibfk_7` (`inactive_by`),
  KEY `nickname` (`nickname`),
  CONSTRAINT `users_ibfk_1` FOREIGN KEY (`image`) REFERENCES `images` (`img_id`)  ON DELETE CASCADE,
  CONSTRAINT `users_ibfk_2` FOREIGN KEY (`cover`) REFERENCES `images` (`img_id`)  ON DELETE CASCADE,
  CONSTRAINT `users_ibfk_3` FOREIGN KEY (`city`) REFERENCES `cities` (`ci_id`),
  CONSTRAINT `users_ibfk_4` FOREIGN KEY (`ccity`) REFERENCES `cities` (`ci_id`),
  CONSTRAINT `users_ibfk_6` FOREIGN KEY (`lang`) REFERENCES `languages` (`lan_id`),
  CONSTRAINT `users_ibfk_7` FOREIGN KEY (`inactive_by`) REFERENCES `users` (`user_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3;

/*!40101 SET character_set_client = @saved_cs_client */
;

DROP TABLE IF EXISTS `visitors`;

/*!40101 SET @saved_cs_client     = @@character_set_client */
;

/*!50503 SET character_set_client = utf8mb4 */
;

CREATE TABLE `visitors` (
  `v_id` int NOT NULL AUTO_INCREMENT,
  `link` varchar(255) NOT NULL COMMENT 'page url ',
  `title` varchar(255) NOT NULL COMMENT 'page title',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(16) DEFAULT NULL,
  `country` varchar(5) NOT NULL COMMENT 'country code',
  `browser` varchar(25) NOT NULL,
  `lang` varchar(5) NOT NULL COMMENT 'vistor  language ',
  `user_id` int DEFAULT NULL COMMENT 'user_id',
  `product_id` int NOT NULL COMMENT 'Product as  FK',
  `os` varchar(12) NOT NULL,
  PRIMARY KEY (`v_id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  KEY `v_id` (`v_id`),
  CONSTRAINT `visitors_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `visitors_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb3 COMMENT = 'Tracking Vistors users and public users ';

/*!40101 SET character_set_client = @saved_cs_client */
;

/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */
;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */
;

/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */
;

/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */
;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */
;

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (1, '0001_01_01_000001_create_cache_table', 1);

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (2, '0001_01_01_000002_create_jobs_table', 1);

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    3,
    '2024_04_22_161507_create_oauth_personal_access_clients_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    4,
    '2024_04_22_161508_create_oauth_auth_codes_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    5,
    '2024_04_22_161509_create_oauth_access_tokens_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    6,
    '2024_04_22_161510_create_oauth_clients_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    7,
    '2024_04_22_161511_create_oauth_refresh_tokens_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    8,
    '2024_04_23_140212_add_laravel_users_columns_to_users_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (9, '2024_04_23_142607_create_sessions_table', 1);

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    10,
    '2024_04_24_150605_change_users_columns_length',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    11,
    '2024_04_29_121237_add_verifications_columns_to_users_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    12,
    '2024_04_29_174419_change_login_table_columns_length',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    13,
    '2024_04_30_151946_change_users_columns_to_be_nullable',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    14,
    '2024_05_16_140234_create_social_identities_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    15,
    '2024_05_18_121222_create_password_reset_tokens_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    16,
    '2024_05_25_113124_change_logo_column_length_to_products_table',
    1
  );

INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (
    17,
    '2024_05_25_114857_add_user_type_column_to_users_table',
    1
  );
