<?php

namespace Database\Seeders;

use Laravel\Passport\Client;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PersonalAccessClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Client::factory()->create([
            'id' => config('passport.personal_access_client.id'),
            'user_id' => null,
            'name' => 'SSO API',
            'secret' => config('passport.personal_access_client.secret'),
            'provider' => 'users',
            'redirect' => 'http://localhost',
            'personal_access_client' => true,
            'password_client' => false,
            'revoked' => false,
        ]);
    }
}
