@if (app()->getLocale() == 'en')
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml">

    <head>
        <meta charset="utf-8"> <!-- utf-8 works for most cases -->
        <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- Use the latest (edge) version of IE rendering engine -->
        <meta name="x-apple-disable-message-reformatting"> <!-- Disable auto-scale in iOS 10 Mail entirely -->
        <title></title> <!-- The title tag shows in email notifications, like Android 4.4. -->

        <!-- Web Font / @font-face : BEGIN -->
        <!-- NOTE: If web fonts are not required, lines 10 - 27 can be safely removed. -->

        <!-- Desktop Outlook chokes on web font references and defaults to Times New Roman, so we force a safe fallback font. -->
        <!--[if mso]>
                                                                                <style>
                                                                                    * {
                                                                                        font-family: sans-serif !important;
                                                                                    }
                                                                                </style>
                                                                                <![endif]-->

        <!-- All other clients get the webfont reference; some will render the font and others will silently fail to the fallbacks. More on that here: http://stylecampaign.com/blog/2015/02/webfont-support-in-email/ -->
        <!--[if !mso]><!-->
        <!-- insert web font reference, eg: <link href='https://fonts.googleapis.com/css?family=Roboto:400,700' rel='stylesheet' type='text/css'> -->
        <!--<![endif]-->

        <!-- Web Font / @font-face : END -->

        <!-- CSS Reset -->
        <style>
            /* What it does: Remove spaces around the email design added by some email clients. */
            /* Beware: It can remove the padding / margin and add a background color to the compose a reply window. */
            html,
            body {
                margin: 0 auto !important;
                padding: 0 !important;
                height: 100% !important;
                width: 100% !important;
                background-color: #F2F2F2 !important;
            }

            /* What it does: Stops email clients resizing small text. */
            * {
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
            }

            /* What is does: Centers email on Android 4.4 */
            div[style*="margin: 16px 0"] {
                margin: 0 !important;
            }

            /* What it does: Stops Outlook from adding extra spacing to tables. */
            table,
            td {
                mso-table-lspace: 0pt !important;
                mso-table-rspace: 0pt !important;
            }

            /* What it does: Fixes webkit padding issue. Fix for Yahoo mail table alignment bug. Applies table-layout to the first 2 tables then removes for anything nested deeper. */
            table {
                border-spacing: 0 !important;
                border-collapse: collapse !important;
                table-layout: fixed !important;
                margin: 0 auto !important;
            }

            table table table {
                table-layout: auto;
            }

            /* What it does: Uses a better rendering method when resizing images in IE. */
            img {
                -ms-interpolation-mode: bicubic;
            }

            /* What it does: A work-around for iOS meddling in triggered links. */
            *[x-apple-data-detectors] {
                color: inherit !important;
                text-decoration: none !important;
            }

            /* What it does: A work-around for Gmail meddling in triggered links. */
            .x-gmail-data-detectors,
            .x-gmail-data-detectors *,
            .aBn {
                border-bottom: 0 !important;
                cursor: default !important;
            }


            /* What it does: Prevents underlining the button text in Windows 10 */
            .button-link {
                text-decoration: none !important;
            }

            /* What it does: Removes right gutter in Gmail iOS app: https://github.com/TedGoas/Cerberus/issues/89  */
            /* Create one of these media queries for each additional viewport size you'd like to fix */
            /* Thanks to Eric Lepetit @ericlepetitsf) for help troubleshooting */
            @media only screen and (min-device-width: 375px) and (max-device-width: 413px) {

                /* iPhone 6 and 6+ */
                .email-container {
                    min-width: 375px !important;
                }

                p {
                    font-size: 12px !important;
                }

                p {
                    font-size: 12px !important;
                }
            }
        </style>

        <!-- Progressive Enhancements -->
        <style>
            /* What it does: Hover styles for buttons */
            .button-td,
            .button-a {
                transition: all 100ms ease-in;
            }

            .button-td:hover,
            .button-a:hover {
                background: #555555 !important;
                border-color: #555555 !important;
            }
        </style>

    </head>

    <body width="100%" bgcolor="white" style="margin: 0; mso-line-height-rule: exactly;" dir="ltr">
        <center style="width: 100%; background-color: #F2F2F2 !important;">

            <!--
                                                                                    Set the email width. Defined in two places:
                                                                                    1. max-width for all clients except Desktop Windows Outlook, allowing the email to squish on narrow but never go wider than 600px.
                                                                                    2. MSO tags for Desktop Windows Outlook enforce a 600px width.
                                                                                -->
            <div style="max-width: 600px!important; margin: auto;" class="email-container">
                <!--[if mso]>
                                                                                    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" align="center">
                                                                                        <tr>
                                                                                            <td>
                                                                                    <![endif]-->



                <!-- Email Body : BEGIN -->
                <table role="presentation" cellspacing="0" cellpadding="0" border="0" align="center" width="100%"
                    style="max-width: 600px !important; ">



                    <!-- Email Body : BEGIN -->
                    <tr>
                        <td bgcolor="#ffffff">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <!-- Body -->

                                    <td
                                        style="font-family: sans-serif; font-size: 15px; line-height: 20px; color: #555555;">

                                        <table border="0" cellpadding="0" cellspacing="0"
                                            class="galileo-ap-layout-editor" style="border-collapse: collapse;"
                                            width="100%">
                                            <tbody>

                                                <tr>
                                                    <td border="0" bgcolor="#1c1c1c" align="left"
                                                        style="padding: 10px 0 5px 0;">
                                                        <!-- <img src="<?php //echo Helper::DOMAIN;
                                                        ?>/images/illafLogo.png" -->
                                                        <!-- <img src="{{ request()->host() }}/illafLogo.png" alt="ICTM" width="190" height="50" -->
                                                        <img src="https://dashboard.semicolonplus.com/lightLogo.png"
                                                            alt="ICTM" width="190" height="50"
                                                            style="display: block;" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#9d060c" style="height: 7px;">

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" align="left"
                                                        style="padding: 15px 15px 15px 15px;font-size:35px;color: #ffffff;font-family: 'Arial'; "
                                                        bgcolor="#b1252a">
                                                        {{ __('Hello!') }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#ffffff"
                                                        style="font-size:15px;font-family: 'Arial ';color:black;padding: 15px 15px 15px 15px; ">
                                                        <p>
                                                            {{ Lang::get('Please copy the code below and paste it in code input the verify page.') }}
                                                        </p>
                                                        <p>
                                                        <h2>{{ $data['verificationCode'] }}</h2>
                                                        </p>
                                                        <a href="{{ $data['link'] }}">{{ __('Activation page') }}</a>
                                                        <br>
                                                        <p>
                                                            {{ Lang::get('If you did not create an account, no further action is required.') }}
                                                        </p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#9d060c"
                                                        style="font-size:12px;font-family: 'Arial ';padding: 20px 20px 20px 20px;color: white !important;"
                                                        align="center" valign=center>

                                                        <table border="0" width="60%" valign=center>

                                                            <tr>
                                                                <td colspan="4">
                                                                    <p align="center" dir="ltr"> ©
                                                                        {{ date('Y') }}
                                                                        ILLAFTrain
                                                                </td>
                                                            </tr>
                                                        </table>

                                                    </td>

                                                </tr>

                                            </tbody>
                                        </table>


                                        <!-- End body-->

                                    </td>
                                </tr>

                                <!-- Email Body : END -->
                            </table>
                            <!-- Email Body : END -->

                            <!--[if mso]>
                                                                                                </td>
                                                                                                </tr>
                                                                                                </table>
                                                                                                <![endif]-->
            </div>
        </center>
    </body>

    </html>
@endif
@if (app()->getLocale() == 'ar')
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml">

    <head>
        <meta charset="utf-8"> <!-- utf-8 works for most cases -->
        <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- Use the latest (edge) version of IE rendering engine -->
        <meta name="x-apple-disable-message-reformatting"> <!-- Disable auto-scale in iOS 10 Mail entirely -->
        <title></title> <!-- The title tag shows in email notifications, like Android 4.4. -->

        <!-- Web Font / @font-face : BEGIN -->
        <!-- NOTE: If web fonts are not required, lines 10 - 27 can be safely removed. -->

        <!-- Desktop Outlook chokes on web font references and defaults to Times New Roman, so we force a safe fallback font. -->
        <!--[if mso]>
                                                                                <style>
                                                                                    * {
                                                                                        font-family: sans-serif !important;
                                                                                    }
                                                                                </style>
                                                                                <![endif]-->

        <!-- All other clients get the webfont reference; some will render the font and others will silently fail to the fallbacks. More on that here: http://stylecampaign.com/blog/2015/02/webfont-support-in-email/ -->
        <!--[if !mso]><!-->
        <!-- insert web font reference, eg: <link href='https://fonts.googleapis.com/css?family=Roboto:400,700' rel='stylesheet' type='text/css'> -->
        <!--<![endif]-->

        <!-- Web Font / @font-face : END -->

        <!-- CSS Reset -->
        <style>
            /* What it does: Remove spaces around the email design added by some email clients. */
            /* Beware: It can remove the padding / margin and add a background color to the compose a reply window. */
            html,
            body {
                margin: 0 auto !important;
                padding: 0 !important;
                height: 100% !important;
                width: 100% !important;
                background-color: #F2F2F2 !important;
            }

            /* What it does: Stops email clients resizing small text. */
            * {
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
            }

            /* What is does: Centers email on Android 4.4 */
            div[style*="margin: 16px 0"] {
                margin: 0 !important;
            }

            /* What it does: Stops Outlook from adding extra spacing to tables. */
            table,
            td {
                mso-table-lspace: 0pt !important;
                mso-table-rspace: 0pt !important;
            }

            /* What it does: Fixes webkit padding issue. Fix for Yahoo mail table alignment bug. Applies table-layout to the first 2 tables then removes for anything nested deeper. */
            table {
                border-spacing: 0 !important;
                border-collapse: collapse !important;
                table-layout: fixed !important;
                margin: 0 auto !important;
            }

            table table table {
                table-layout: auto;
            }

            /* What it does: Uses a better rendering method when resizing images in IE. */
            img {
                -ms-interpolation-mode: bicubic;
            }

            /* What it does: A work-around for iOS meddling in triggered links. */
            *[x-apple-data-detectors] {
                color: inherit !important;
                text-decoration: none !important;
            }

            /* What it does: A work-around for Gmail meddling in triggered links. */
            .x-gmail-data-detectors,
            .x-gmail-data-detectors *,
            .aBn {
                border-bottom: 0 !important;
                cursor: default !important;
            }


            /* What it does: Prevents underlining the button text in Windows 10 */
            .button-link {
                text-decoration: none !important;
            }

            /* What it does: Removes right gutter in Gmail iOS app: https://github.com/TedGoas/Cerberus/issues/89  */
            /* Create one of these media queries for each additional viewport size you'd like to fix */
            /* Thanks to Eric Lepetit @ericlepetitsf) for help troubleshooting */
            @media only screen and (min-device-width: 375px) and (max-device-width: 413px) {

                /* iPhone 6 and 6+ */
                .email-container {
                    min-width: 375px !important;
                }

                p {
                    font-size: 12px !important;
                }

                p {
                    font-size: 12px !important;
                }
            }
        </style>

        <!-- Progressive Enhancements -->
        <style>
            /* What it does: Hover styles for buttons */
            .button-td,
            .button-a {
                transition: all 100ms ease-in;
            }

            .button-td:hover,
            .button-a:hover {
                background: #555555 !important;
                border-color: #555555 !important;
            }
        </style>

    </head>

    <body width="100%" bgcolor="white" style="margin: 0; mso-line-height-rule: exactly;" dir="rtl">
        <center style="width: 100%;  background-color: #F2F2F2 !important;">

            <!--
                                                                                    Set the email width. Defined in two places:
                                                                                    1. max-width for all clients except Desktop Windows Outlook, allowing the email to squish on narrow but never go wider than 600px.
                                                                                    2. MSO tags for Desktop Windows Outlook enforce a 600px width.
                                                                                -->
            <div style="max-width: 600px!important; margin: auto;" class="email-container">
                <!--[if mso]>
                                                                                    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" align="center">
                                                                                        <tr>
                                                                                            <td>
                                                                                    <![endif]-->

                <!-- Email Body : BEGIN -->
                <table role="presentation" cellspacing="0" cellpadding="0" border="0" align="center"
                    width="100%" style="max-width: 600px !important; ">



                    <!-- Email Body : BEGIN -->
                    <tr>
                        <td bgcolor="#ffffff">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0"
                                width="100%">
                                <tr>
                                    <!-- Body -->

                                    <td
                                        style="font-family: sans-serif; font-size: 15px; line-height: 20px; color: #555555;">

                                        <table border="0" cellpadding="0" cellspacing="0"
                                            class="galileo-ap-layout-editor" style="border-collapse: collapse;"
                                            width="100%">
                                            <tbody>

                                                <tr>
                                                    <td border="0" bgcolor="#1c1c1c" align="left"
                                                        style="padding: 10px 0 5px 0;">
                                                        <!-- <img src="<?php //echo Helper::DOMAIN;
                                                        ?>/images/illafLogo.png" -->
                                                        <img src="https://dashboard.semicolonplus.com/lightLogo.png"
                                                            alt="ICTM" width="190" height="50"
                                                            style="display: block;" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#9d060c" style="height: 7px;">

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" align="right"
                                                        style="padding: 15px 15px 15px 15px;font-size:35px;color: #ffffff;font-family: 'Arial'; "
                                                        bgcolor="#b1252a">
                                                        {{ __('Hello!') }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#ffffff"
                                                        style="font-size:15px;font-family: 'Arial ';color:black;padding: 20px 20px 20px 20px; ">
                                                        <p>
                                                            {{ Lang::get('Please copy the code below and paste it in code input the verify page.') }}
                                                        </p>
                                                        <p>
                                                        <h2>{{ $data['verificationCode'] }}</h2>
                                                        </p>
                                                        <p><a
                                                                href="{{ $data['link'] }}">{{ __('Activation page') }}</a>
                                                        </p>
                                                        <p>
                                                            {{ Lang::get('If you did not create an account, no further action is required.') }}
                                                        </p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td border="0" bgcolor="#9d060c"
                                                        style="font-size:12px;font-family: 'Arial ';padding: 20px 20px 20px 20px;color: white !important;"
                                                        align="center" valign=center>

                                                        <table border="0" width="60%" valign=center>

                                                            <tr>
                                                                <td colspan="4">
                                                                    <p align="center" dir="ltr"> ©
                                                                        {{ date('Y') }}
                                                                        ILLAFTrain
                                                                </td>
                                                            </tr>
                                                        </table>

                                                    </td>

                                                </tr>

                                            </tbody>
                                        </table>


                                        <!-- End body-->

                                    </td>
                                </tr>

                                <!-- Email Body : END -->

                            </table>
                            <!-- Email Body : END -->



                            <!--[if mso]>
                                                                                    </td>
                                                                                    </tr>
                                                                                    </table>
                                                                                    <![endif]-->
            </div>
        </center>
    </body>

    </html>
@endif
