<?php

namespace Tests\Feature;

use App\Models\City;
use App\Models\Country;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class CitiesTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test getting cities.
     *
     * @return void
     */
    public function testGetCities()
    {
        $country = Country::factory()->create();
        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;
        City::factory()->create(['co_id' => $country->co_id]);

        $response = $this->getJson('/api/data/' . $country->co_id . '/cities', [
            'product' => $product_id,
            'product-key' => $key,
        ]);
        $response->assertStatus(200);

        $response = $this->getJson('/api/data/' . 999 . '/cities', ['product' => $product_id]);
        $response->assertStatus(404);
    }
}
