<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ProductUsersTest extends TestCase
{
    use RefreshDatabase;

    public function test_can_get_a_list_of_products_users(): void
    {
        $firstUser = User::factory()->create();
        $secondUser = User::factory()->create();
        $product = Product::factory()->create();
        $key = $product->key;

        $firstUser->products()->attach($product->product_id, [
            'active' => 1,
            'ldate' => now(),
            'date' => now(),
            'language' => app()->getLocale(),
        ]);
        $secondUser->products()->attach($product->product_id, [
            'active' => 1,
            'ldate' => now(),
            'date' => now(),
            'language' => app()->getLocale(),
        ]);

        $this->actingAs($firstUser, 'api');

        $response = $this->getJson(route('products.users', [
            'product' => $product->product_id,
        ]),
            [
                'product' => $product->product_id,
                'product-key' => $key,
            ]
        );

        $response->assertStatus(200);
        $response->assertJson([
            'success' => true,
        ]);
        $this->assertCount(2, $response->json('users'));
    }
}
