<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;

class UserActivationTest extends TestCase
{
    use RefreshDatabase;

    public function testToggleUserActivation()
    {
        $user = User::factory()->create(['active' => 1]);

        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;

        $this->actingAs($user, 'api');

        $response = $this->putJson(
            '/api/users/' . $user->user_id . '/toggle-activation',
            headers: [
                'product' => $product_id,
                'product-key' => $key,
            ]
        );

        $response->assertStatus(200)
            ->assertJson(['message' => __('User activation active toggled successfully')]);

        $user->refresh();
        $this->assertEquals(0, $user->active);
    }
}
