<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;

class UserPreferencesTest extends TestCase
{
    use RefreshDatabase;

    public function testGetUserPreferences(): void
    {
        $user = User::factory()->create();
        $product = Product::factory()->create();

        $this->actingAs($user, 'api');

        $response = $this->getJson('/api/users/' . $user->user_id . '/preferences', headers: [
            'product' => $product->product_id,
            'product-key' => $product->key,
        ]);
        // dd($response->getContent());
        $response->assertJsonFragment([
            'success' => true,
            'data' => [
                'user_id' => $user->user_id,
                'time_zone' => $user->time_zone,
                'dark_mode' => $user->dark_mode,
                'gender' => $user->gender,
                'birthday' => $user->bdate,
                'language' => $user->language,
            ],
        ]);
    }
}
